' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

''' <summary>
''' Klasa Configuration eksponuje waciwoci publiczne i tylko do odczytu dla potrzeb konfiguracji.
''' </summary>
Public Class AppConfiguration

  ''' <summary>
  ''' Ukryj konstruktor, aby unikn tworzenia egzemplarzy klasy AppConfiguration.
  ''' </summary>
  Private Sub New()
  End Sub

  ''' <summary>
  ''' Zwraca the acuch poczenia dla Systemu Rezerwacji On-line.
  ''' </summary>
  Public Shared ReadOnly Property ConnectionString() As String
    Get
      Dim tempValue As String = "server=(local)\SqlExpress;AttachDbFileName=|DataDirectory|aspnetdb.mdf;Integrated Security=true;User Instance=true"
      Try
        If ConfigurationManager.ConnectionStrings("AppointmentBooking") IsNot Nothing Then
          tempValue = ConfigurationManager.ConnectionStrings("AppointmentBooking").ConnectionString
        End If
      Catch
        ' Jesli nie moemy pobra ustawienia z pliku konfiguracyjnego, ignorujemy bd i zwracamy
        ' domylny acuch poaczenia wskazujcy na instancj SqlExpress na lokalnym 
        ' komputerze i prbujemy poczy si z baz danych Bazy Bdw automatycznie.
      End Try
      Return tempValue
    End Get
  End Property

  ''' <summary>
  ''' Pobiera warto okrelajc, czy komentarze sa wymagane probie o rezerwacj.
  ''' </summary>
  Public Shared ReadOnly Property RequireCommentsInRequest() As Boolean
    Get
      Dim tempValue As Boolean = True
      Try
        If ConfigurationManager.AppSettings.Get("RequireCommentsInRequest") IsNot Nothing Then
          tempValue = Convert.ToBoolean(ConfigurationManager.AppSettings.Get("RequireCommentsInRequest"))
        End If
      Catch
        ' Ignoruj bd i zwr domyln warto dla tempValue
      End Try
      Return tempValue
    End Get
  End Property

  ''' <summary>
  ''' Pobiera the form liczby pojedynczej przyjaznej uytkownikowi nazwy obiektu rezerwacji.
  ''' </summary>
  Public Shared ReadOnly Property BookingObjectNameSingular() As String
    Get
      Dim tempValue As String = String.Empty
      Try
        If ConfigurationManager.AppSettings.Get("BookingObjectNameSingular") IsNot Nothing Then
          tempValue = ConfigurationManager.AppSettings.Get("BookingObjectNameSingular")
        End If
      Catch
        ' Przepu bd
        Throw
      End Try
      Return tempValue
    End Get
  End Property

  ''' <summary>
  ''' Pobiera form liczby mnogiej przyjaznej uytkownikowi nazwy obiektu rezerwacji.
  ''' </summary>
  Public Shared ReadOnly Property BookingObjectNamePlural() As String
    Get
      Dim tempValue As String = String.Empty
      Try
        If ConfigurationManager.AppSettings.Get("BookingObjectNamePlural") IsNot Nothing Then
          tempValue = ConfigurationManager.AppSettings.Get("BookingObjectNamePlural")
        End If
      Catch
        ' Przepu bd
        Throw
      End Try
      Return tempValue
    End Get
  End Property
End Class
